/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.sfp.srvutil;

import com.ibm.hsc.auiml.databeans.sfp.srvutil.EditMTMSBean;
import com.ibm.hsc.auiml.databeans.sfp.srvutil.ServiceUtilConstants;
import com.ibm.hsc.ccfw.mom.PICec;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIIODrawerConfigIdDataBean;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.websm.sfp.SFPUtil;
import com.ibm.hsc.websm.sfp.ServiceUtilitiesTarget;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruConfig;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetedTasklet;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;

public class EditMTMSTasklet
extends TargetedTasklet
implements ServiceUtilConstants {
    private static final String TRACE_MASKD = "JEDTMTKD";
    private static final String TRACE_MASKF = "JEDTMTKF";
    private static final String TRACE_MASKT = "JEDTMTKT";
    private static final short ERRID_0060 = 96;
    private static final short ERRID_0061 = 97;
    private static final short ERRID_0062 = 98;
    private static final short ERRID_0063 = 99;
    private static final short ERRID_0064 = 100;
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, -128, "SFPUtilEDTM");
    private static final String AUIML_FILE_NAME = "com.ibm.hsc.auiml.databeans.sfp.srvutil.EditMTMS";
    private static final String INITIAL_PANEL = "EditMTMSMainPanel";
    private static final String EDIT_ENCLOSURE_PANEL = "EditMTMSEnclosurePanel";
    private String userDefinedName = null;
    private static final String CMD_LINE_BUNDLE = "PIHscCmdLineBundle";
    private PIHSCCECClient r5Client = null;

    public EditMTMSTasklet() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> EditMTMSTasklet c-tor");
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        block32: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> EditMTMSTasklet.service()");
            if (panelTaskletRequest.isInitialRequest()) {
                Trace.trace((String)TRACE_MASKF, (Object)"-> EditMTMSTasklet.isInitialRequest()");
                EditMTMSBean editMTMSBean = new EditMTMSBean();
                editMTMSBean.setBeanName("EditMTMSBean");
                Target[] targetArray = this.getSelectedTargets();
                String string = targetArray[0].getName().toString();
                Trace.trace((String)TRACE_MASKF, (Object)("-- selected system name is: " + string));
                Object object = ((ServiceUtilitiesTarget)targetArray[0]).getTargetObject();
                if (object instanceof PICec) {
                    this.userDefinedName = ((PICec)object).getUserDefinedName();
                    Trace.trace((String)TRACE_MASKF, (Object)("-- userDefinedName is: " + this.userDefinedName));
                    if (string != null && string.length() != 0) {
                        editMTMSBean.setSelectedSystem(string);
                    }
                    if (this.userDefinedName != null && this.userDefinedName.length() != 0) {
                        editMTMSBean.setUserDefinedName(this.userDefinedName);
                    }
                    try {
                        this.showBusyDialog(new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_ENCLOSURE_TITLE"), new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_ENCLOSURE_TEXT"));
                        this.getInstalledEnclosureInfo(editMTMSBean, this.userDefinedName);
                        panelTaskletResponse.openModalChild(AUIML_FILE_NAME, EDIT_ENCLOSURE_PANEL, (PanelBean)editMTMSBean);
                        this.destroyBusyDialog();
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKD, (Object)("-- unexpected exception querying enclosures: " + exception));
                        this.destroyBusyDialog();
                        new AusMicrocodeLog(_logInfo, 96, exception).writeEntry(null);
                        Trace.trace((String)TRACE_MASKF, (Object)("-- Message is " + exception.getMessage()));
                        String string2 = exception.getMessage().equals("CIMNullClient") ? "0242" : (exception instanceof UnknownHostException ? "0241" : (exception instanceof PIHscClientException ? "0243" : "0245"));
                        Trace.trace((String)TRACE_MASKF, (Object)("-- key is " + string2));
                        try {
                            SFPUtil.showSFPErrorMessageBox(string2, (PanelTasklet)this);
                        }
                        catch (Exception exception2) {
                            Trace.trace((String)TRACE_MASKF, (Object)("-- showSFPErrorMessageBox() exception caught, e is " + exception2));
                        }
                        try {
                            panelTaskletResponse.openModalChild(AUIML_FILE_NAME, EDIT_ENCLOSURE_PANEL, (PanelBean)editMTMSBean);
                        }
                        catch (Exception exception3) {
                            Trace.trace((String)TRACE_MASKF, (Object)("Another exception caught during initial service request, e1 is " + exception3));
                            panelTaskletResponse.terminate();
                        }
                    }
                } else {
                    panelTaskletResponse.noAction();
                }
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)("taskletRequest.getData(command): " + panelTaskletRequest.getData("Command") + "."));
                if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
                    Trace.trace((String)TRACE_MASKF, (Object)"taskletRequest.isDisposed() or isCanceled, issue taskletResponse.dispose().");
                    panelTaskletResponse.dispose();
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)"Some taskletRequest other than Cancel is pending.");
                    String string = (String)panelTaskletRequest.getData("Command");
                    Trace.trace((String)TRACE_MASKF, (Object)("Command is " + string));
                    if (string == null) {
                        panelTaskletResponse.noAction();
                    }
                    if (string.equals("OKButton") || string.equals("COMPLETE")) {
                        Trace.trace((String)TRACE_MASKF, (Object)"Processing Ok Button.");
                        try {
                            EditMTMSBean editMTMSBean = (EditMTMSBean)panelTaskletRequest.getData("DataBean");
                            if (editMTMSBean != null) {
                                int n = editMTMSBean.getEnclosureTableSelection()[0];
                                Trace.trace((String)TRACE_MASKF, (Object)("New ConfigID is " + editMTMSBean.getNewEnclosureConfigID()));
                                Trace.trace((String)TRACE_MASKF, (Object)("New MTMS is " + editMTMSBean.getNewEnclosureMTMS()));
                                Trace.trace((String)TRACE_MASKF, (Object)("Selected row is " + n));
                                PIIODrawerConfigIdDataBean pIIODrawerConfigIdDataBean = editMTMSBean.getEnclosureInfo()[n];
                                String string3 = pIIODrawerConfigIdDataBean.getLoaction_code();
                                Trace.trace((String)TRACE_MASKF, (Object)("loccode is " + string3));
                                String[] stringArray = new String[]{"", ""};
                                this.showBusyDialog(new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_ENCLOSURE_TITLE"), new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_SYSTEM_TEXT"));
                                if (editMTMSBean.getNewEnclosureConfigID() != null) {
                                    Trace.trace((String)TRACE_MASKF, (Object)"Setting new ConfigID");
                                    try {
                                        int n2 = new Integer(editMTMSBean.getNewEnclosureConfigID());
                                        Trace.trace((String)TRACE_MASKF, (Object)("New ConfigID is " + n2));
                                        this.r5Client.setIoDrawerConfifId(n2, string3);
                                        stringArray[1] = "GOOD";
                                    }
                                    catch (Exception exception) {
                                        Trace.trace((String)TRACE_MASKF, (Object)("-- setIoDrawerConfifId() exception caught, e is" + exception));
                                        stringArray[1] = exception.getLocalizedMessage();
                                        new AusMicrocodeLog(_logInfo, 98, exception).writeEntry(null);
                                    }
                                }
                                if (editMTMSBean.getNewEnclosureMTMS() != null) {
                                    Trace.trace((String)TRACE_MASKF, (Object)"Setting new MTMS");
                                    try {
                                        String string4 = editMTMSBean.getNewEnclosureMTMS();
                                        Trace.trace((String)TRACE_MASKF, (Object)("New MTMS is " + string4));
                                        String[] stringArray2 = editMTMSBean.parseNewMTMS(string4);
                                        if (stringArray2 != null) {
                                            Trace.trace((String)TRACE_MASKF, (Object)("Parsed data is type/model/serial " + stringArray2[0] + "/" + stringArray2[1] + "/" + stringArray2[2]));
                                            Trace.trace((String)TRACE_MASKF, (Object)("r5Client " + this.r5Client));
                                            this.r5Client.setIoDrawerMtms(stringArray2[0], stringArray2[1], stringArray2[2], string3);
                                            stringArray[0] = "GOOD";
                                        }
                                    }
                                    catch (Exception exception) {
                                        Trace.trace((String)TRACE_MASKF, (Object)("-- setIoDrawerMTMS() exception caught, e is" + exception));
                                        stringArray[0] = exception.getLocalizedMessage();
                                        new AusMicrocodeLog(_logInfo, 97, exception).writeEntry(null);
                                    }
                                }
                                Trace.trace((String)TRACE_MASKF, (Object)"-- before testing status");
                                if (stringArray[0].equals("GOOD") || stringArray[1].equals("GOOD")) {
                                    Trace.trace((String)TRACE_MASKF, (Object)"-- get the updated data");
                                    try {
                                        this.getAllEnclosureInfo(this.r5Client, editMTMSBean);
                                    }
                                    catch (Exception exception) {
                                        Trace.trace((String)TRACE_MASKD, (Object)("-- unexpected exception querying update data: " + exception));
                                        try {
                                            SFPUtil.showSFPErrorMessageBox("0245", (PanelTasklet)this);
                                        }
                                        catch (Exception exception4) {
                                            Trace.trace((String)TRACE_MASKF, (Object)("-- showSFPErrorMessageBox() exception caught, e is " + exception4));
                                        }
                                    }
                                }
                                this.destroyBusyDialog();
                                Trace.trace((String)TRACE_MASKF, (Object)"-- update the panel with the new data");
                                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                hashMap.put("DataBean", editMTMSBean);
                                hashMap.put("UpdateData", stringArray);
                                panelTaskletResponse.update(hashMap);
                                break block32;
                            }
                            Trace.trace((String)TRACE_MASKF, (Object)"-- bean is null");
                            panelTaskletResponse.noAction();
                        }
                        catch (Exception exception) {
                            Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, e is" + exception));
                            panelTaskletResponse.noAction();
                        }
                    } else {
                        Trace.trace((String)TRACE_MASKT, (Object)"Unknown tasklet request sent to ReplaceFRUTasklet.");
                        panelTaskletResponse.noAction();
                    }
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- EditMTMSTasklet.service()");
    }

    public void getInstalledEnclosureInfo(EditMTMSBean editMTMSBean, String string) throws Exception {
        block5: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> EditMTMSTasklet.getAllEnclosureInfo()");
            try {
                this.r5Client = this.createCECClient(string);
                if (null != this.r5Client) {
                    try {
                        this.getAllEnclosureInfo(this.r5Client, editMTMSBean);
                        Trace.trace((String)TRACE_MASKD, (Object)"-- getAllSysInfo() completed successfully");
                        break block5;
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- exception caught during getAllSysInfo(), exception is: " + exception));
                        throw exception;
                    }
                }
                Trace.trace((String)TRACE_MASKF, (Object)"-- could not create the CEC CIM client");
                throw new Exception("CIMNullClient");
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, rethrowing..." + exception));
                throw exception;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- EditMTMSTasklet.getAllEnclosureInfo()");
    }

    private PIHSCCECClient createCECClient(String string) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> EditMTMSTasklet.createCECClient()");
        PIHSCCECClient pIHSCCECClient = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            Trace.trace((String)TRACE_MASKF, (Object)("-- theHostName is: " + string2));
            try {
                PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, null);
                String string3 = string;
                Trace.trace((String)TRACE_MASKD, (Object)("-- theSystem (selected system name) is: " + string3));
                pIHSCCECClient = pIHSCClientObjectFactory.createCECClient(string3, false);
                Trace.trace((String)TRACE_MASKF, (Object)("client (after createCECClient()) " + pIHSCCECClient));
                if (null == pIHSCCECClient) {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- Cannot create PIHSCCECClient - client is null");
                    try {
                        throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "MANAGED_SYSTEM_NOT_FOUND", null, null);
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- Could not throw new PIHscClientException, exception is: " + exception));
                        throw exception;
                    }
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception building the client is: " + exception));
                throw exception;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- no HMC hostname, Exception is: " + unknownHostException));
            throw unknownHostException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- EditMTMSTasklet.createCECClient()");
        return pIHSCCECClient;
    }

    protected void getAllEnclosureInfo(PIHSCCECClient pIHSCCECClient, EditMTMSBean editMTMSBean) throws Exception {
        block7: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> EditMTMSTasklet.getAllEnclosureInfo()");
            PIIODrawerConfigIdDataBean[] pIIODrawerConfigIdDataBeanArray = null;
            try {
                pIIODrawerConfigIdDataBeanArray = pIHSCCECClient.getIoDrawerConfigIdAndMtms(PIIODrawerConfigIdDataBean.ALL_KEYS);
                Trace.trace((String)TRACE_MASKF, (Object)("-- Number of PIIODrawerConfigIdDataBeans returned is " + pIIODrawerConfigIdDataBeanArray.length));
                if (pIIODrawerConfigIdDataBeanArray == null || pIIODrawerConfigIdDataBeanArray.length <= 0) break block7;
                int n = pIIODrawerConfigIdDataBeanArray.length;
                String string = editMTMSBean.getSelectedSystem();
                String string2 = string.substring(0, 4);
                String string3 = string.substring(5, 8);
                Trace.trace((String)TRACE_MASKF, (Object)("-- MTMS is: " + string));
                Trace.trace((String)TRACE_MASKF, (Object)("-- type is: " + string2));
                Trace.trace((String)TRACE_MASKF, (Object)("-- model is: " + string3));
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    Trace.trace((String)TRACE_MASKF, (Object)("-- loccode[" + i + "] is " + pIIODrawerConfigIdDataBeanArray[i].getLoaction_code()));
                    stringArray[i] = pIIODrawerConfigIdDataBeanArray[i].getLoaction_code();
                }
                try {
                    Trace.trace((String)TRACE_MASKF, (Object)("Before constructing FruConfig object, type/model = " + string2 + "/" + string3));
                    FruConfig fruConfig = new FruConfig(string2, string3);
                    Trace.trace((String)TRACE_MASKF, (Object)"-- After FruConfig constructor");
                    String[] stringArray2 = null;
                    try {
                        stringArray2 = fruConfig.queryDescriptionsByLocation(stringArray, null);
                        Trace.trace((String)TRACE_MASKF, (Object)("-- Number of enclosure types returned from queryDescriptionsByLocation() is " + stringArray2.length));
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- Exception getting enclosure types " + exception));
                    }
                    editMTMSBean.setEnclosureTypes(stringArray2);
                    editMTMSBean.setEnclosureInfo(pIIODrawerConfigIdDataBeanArray);
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, e is <" + exception + ">"));
                    throw exception;
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking getIoDrawerConfigIdAndMtms() cmd. Exception is: " + exception));
                throw exception;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- EditMTMSTasklet.getAllEnclosureInfo()");
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> EditMTMSTasklet.logException()");
        Trace.trace((String)TRACE_MASKT, (Object)("processing exception: " + throwable));
        HException hException = new HException(throwable);
        Trace.trace((String)TRACE_MASKT, (Object)"<- EditMTMSTasklet.logException()");
    }
}

